/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.iotcore.facade.util;

import com.fshows.lifecircle.iotcore.facade.enums.DisplayPayTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PayTypeConvert {
    public static final List<Integer> WECHAT_PAY = Arrays.asList(1, 11, 12, 13);
    public static final List<Integer> ALIPAY_PAY = Arrays.asList(2, 7, 21, 22, 23, 24);
    public static final List<Integer> UNION_PAY = Collections.singletonList(5);
    public static final List<Integer> BANKCARD_PAY = Arrays.asList(9, 91);
    public static final List<Integer> IOT_ALL_PAY_TYPE = Arrays.asList(1, 11, 12, 13, 2, 7, 21, 22, 23, 24, 5, 9, 91, 33);

    public static List<Integer> convertToPayTypeList(DisplayPayTypeEnum payTypeParamEnum) {
        if (DisplayPayTypeEnum.WECHAT_PAY.equals((Object)payTypeParamEnum)) {
            return WECHAT_PAY;
        }
        if (DisplayPayTypeEnum.ALIPAY_PAY.equals((Object)payTypeParamEnum)) {
            return ALIPAY_PAY;
        }
        if (DisplayPayTypeEnum.UNION_PAY.equals((Object)payTypeParamEnum)) {
            return UNION_PAY;
        }
        if (DisplayPayTypeEnum.BANKCARD_PAY.equals((Object)payTypeParamEnum)) {
            return BANKCARD_PAY;
        }
        return Collections.emptyList();
    }

    public static List<Integer> convertToPayTypeList(List<DisplayPayTypeEnum> payTypeParamEnumList) {
        ArrayList<Integer> payTypeList = new ArrayList<Integer>();
        for (DisplayPayTypeEnum displayPayTypeEnum : payTypeParamEnumList) {
            payTypeList.addAll(PayTypeConvert.convertToPayTypeList(displayPayTypeEnum));
        }
        return payTypeList;
    }

    public static DisplayPayTypeEnum reconvert(Integer payType) {
        for (DisplayPayTypeEnum payTypeParamEnum : DisplayPayTypeEnum.values()) {
            if (!PayTypeConvert.convertToPayTypeList(payTypeParamEnum).contains(payType)) continue;
            return payTypeParamEnum;
        }
        return DisplayPayTypeEnum.OTHER;
    }
}

