/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.acctbizcore.facade.enums.exception;

import com.fshows.fsframework.common.exception.FsInternalException;
import com.fshows.lifecircle.acctbizcore.facade.constants.AccountConstant;
import com.fshows.lifecircle.acctbizcore.facade.enums.exception.base.ErrorCodeEnum;

public enum ResourceErrorEnum {
    FILE_SIZE_LIMIT(ErrorCodeEnum.FILE_DATA_INVALID, "\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236"),
    FILE_TYPE_INVALID(ErrorCodeEnum.FILE_DATA_INVALID, "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5"),
    IMAGE_TYPE_INVALID(ErrorCodeEnum.FILE_DATA_INVALID, "\u56fe\u7247\u683c\u5f0f\u4e0d\u5408\u6cd5"),
    FILE_NOT_FOUND(ErrorCodeEnum.FILE_DATA_INVALID, "\u6587\u4ef6\u8d44\u6e90\u4e0d\u5b58\u5728"),
    FILE_UPLOAD_FAIL(ErrorCodeEnum.FILE_HANDLE_ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"),
    FILE_ENCRYPTION_FAIL(ErrorCodeEnum.FILE_HANDLE_ERROR, "\u6587\u4ef6\u52a0\u5bc6\u5931\u8d25"),
    IMAGE_ID_INVALID(ErrorCodeEnum.FILE_DATA_INVALID, "\u56fe\u7247\u8d44\u6e90id\u65e0\u6548\u6216\u5df2\u8fc7\u671f"),
    OSS_CONFIG_ERROR(ErrorCodeEnum.OSS_CONFIG_ERROR, "\u83b7\u53d6oss\u914d\u7f6e\u5931\u8d25");

    private final ErrorCodeEnum code;
    private final String msg;

    private ResourceErrorEnum(ErrorCodeEnum code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ErrorCodeEnum getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String subCode() {
        return this.code.getErrorBusinessType().getSubCodePrefix() + "." + this.name();
    }

    public FsInternalException exception() {
        return new FsInternalException(this.code.getErrorCode(), this.subCode(), this.msg).init(AccountConstant.EXCEPTION_PROJECT_ID, this.code.getErrorBusinessType().getBusinessType());
    }

    public FsInternalException exception(String msg) {
        return new FsInternalException(this.code.getErrorCode(), this.subCode(), msg).init(AccountConstant.EXCEPTION_PROJECT_ID, this.code.getErrorBusinessType().getBusinessType());
    }
}

