/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.accountcore.facade.enums;

import com.fshows.lifecircle.accountcore.facade.enums.WithdrawModeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public enum WithdrawFundTypeEnum {
    PAYMENT_TYPE("\u6536\u5355\u6b3e", 1),
    DOUYIN_TYPE("\u6296\u97f3\u6838\u9500\u6b3e", 2),
    BLUE_TYPE("\u652f\u4ed8\u5b9d\u8865\u8d34\u6b3e", 3),
    MARKET_TYPE("\u91d1\u5361\u8865\u8d34\u6b3e", 4),
    ALIPAY_VOUCHER_TYPE("\u652f\u4ed8\u5b9d\u6838\u9500\u6b3e", 5);

    private final String name;
    private final Integer value;

    private WithdrawFundTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static WithdrawFundTypeEnum getByValue(Integer value) {
        WithdrawFundTypeEnum[] valueList;
        for (WithdrawFundTypeEnum v : valueList = WithdrawFundTypeEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static List<Integer> convertByFundType(Integer fundType) {
        WithdrawFundTypeEnum fundTypeEnum = WithdrawFundTypeEnum.getByValue(fundType);
        ArrayList withdrawModeList = PAYMENT_TYPE.equals((Object)fundTypeEnum) ? Lists.newArrayList((Object[])new Integer[]{WithdrawModeEnum.MODE_USER.getValue(), WithdrawModeEnum.MODE_AUTOMATIC.getValue(), WithdrawModeEnum.MODE_SPECIAL.getValue(), WithdrawModeEnum.MODE_EXCEPTION.getValue(), WithdrawModeEnum.MODE_SHARE.getValue(), WithdrawModeEnum.MODE_BALANCE_AUTOMATIC.getValue()}) : (DOUYIN_TYPE.equals((Object)fundTypeEnum) ? Lists.newArrayList((Object[])new Integer[]{WithdrawModeEnum.MODE_DOUYIN.getValue()}) : (BLUE_TYPE.equals((Object)fundTypeEnum) ? Lists.newArrayList((Object[])new Integer[]{WithdrawModeEnum.MODE_BLUE.getValue()}) : (MARKET_TYPE.equals((Object)fundTypeEnum) ? Lists.newArrayList((Object[])new Integer[]{WithdrawModeEnum.MODE_MARKET.getValue()}) : (ALIPAY_VOUCHER_TYPE.equals((Object)fundTypeEnum) ? Lists.newArrayList((Object[])new Integer[]{WithdrawModeEnum.MODE_ALIPAY_VOUCHER.getValue()}) : Lists.newArrayList()))));
        return withdrawModeList;
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }
}

