/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhoujp
 * @version LeshuaBankActivityInfoResponse.java, v 0.1 2023-07-27 11:04 zhoujp
 */
@Data
public class LeshuaBankActivityMerchantResponse implements Serializable {

    private static final long serialVersionUID = 5672919363905224884L;
    /**
     * 活动编号
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 绑卡状态0=无效，10=未预约，20=已预约，30=已开卡，40=已绑卡
     */
    private Integer cardBindStatus;

    /**
     * 活动状态1：未上架；2：进行中；3：已下架；4：已过期
     */
    private Integer activityStatus;

    /**
     * cardBinLength 卡bin位数
     */
    private Integer cardBinLength;

    /**
     * 活动卡bin
     */
    private String cardBins;

    /**
     * 银行名字
     */
    private String bankName;

}