/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.settlement.MerchantSettleResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户入驻
 *
 * @author zhaoyi
 * @version MerchantSettleRequest.java, v 0.1 2020-07-27 11:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantSettleRequest extends LeshuaBizRequest<MerchantSettleResponse> {

    /**
     * 商户基本信息
     */
    private BaseInfo baseInfo;

    /**
     * 法人信息，个人类型填联系人信息
     */
    private LegalPerson legalPerson;

    /**
     * 联系人信息
     */
    private ContactInfo contactInfo;

    /**
     * 店铺地址信息
     */
    private AddressInfo addressInfo;

    /**
     * 营业资质信息
     * 小微进件不要传此对象
     */
    private LicenseInfo licenseInfo;

    /**
     * 结算信息
     */
    private AccountInfo accountInfo;

    /**
     * 门店信息
     */
    private ShopInfo shopInfo;

    /**
     * 微信信息
     */
    private WechatInfo wechatInfo;

    /**
     * 其它信息
     */
    private OtherInfo otherInfo;

    @Override
    public Class<MerchantSettleResponse> getResponseClass() {
        return MerchantSettleResponse.class;
    }
}
