/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantWxPayConfigQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户支付参数查询request
 *
 * @author zhaoyi
 * @version MerchantWxPayConfigQueryRequest.java, v 0.1 2020-07-29 14:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantWxPayConfigQueryRequest extends LeshuaBizRequest<MerchantWxPayConfigQueryResponse> {

    /**
     * 商户编号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;

    /**
     * 商户渠道号ID
     * 商户上报的微信渠道号ID（只有一个渠道号无需填写此字段）
     */
    private Integer reportConfigId;

    /**
     * 微信商户号
     * 参加绿洲后，配置参数必填
     */
    @Length(max = 10, message = "wxSubMchId超长")
    private String wxSubMchId;

    @Override
    public Class<MerchantWxPayConfigQueryResponse> getResponseClass() {
        return MerchantWxPayConfigQueryResponse.class;
    }

}
