/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 微信商户实名认证状态枚举
 *
 * @author zhaoyi
 * @version WxApplyStatusEnum.java, v 0.1 2020-08-03 14:48 zhaoyi
 */
public enum WxApplyStatusEnum {
    WAIT_FOR_UPLOAD_DATA("WAIT_FOR_UPLOAD_DATA", "等待上送资料"),
    UPLOAD_DATA_FAIL("UPLOAD_DATA_FAIL", "上送资料失败"),
    APPLYMENT_STATE_WAITTING_FOR_AUDIT("APPLYMENT_STATE_WAITTING_FOR_AUDIT", "微信审核中"),
    APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT("APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT", "待确认联系信息"),
    APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON("APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON", "待账户验证"),
    APPLYMENT_STATE_PASSED("APPLYMENT_STATE_PASSED", "审核通过"),
    APPLYMENT_STATE_REJECTED("APPLYMENT_STATE_REJECTED", "审核驳回"),
    APPLYMENT_STATE_FREEZED("APPLYMENT_STATE_FREEZED", "已冻结"),
    APPLYMENT_STATE_CANCELED("APPLYMENT_STATE_CANCELED", "已作废"),
    ;

    private String code;
    private String desc;

    WxApplyStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static WxApplyStatusEnum getByType(String code) {
        WxApplyStatusEnum[] valueList = WxApplyStatusEnum.values();
        for (WxApplyStatusEnum v : valueList) {
            if (v.getCode().equalsIgnoreCase(code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */
    public String getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
