/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 支付类型枚举
 *
 * @author zhaoyi
 * @version PayTypeEnum.java, v 0.1 2020-08-03 15:08 zhaoyi
 */
public enum PayTypeEnum {
    WXZF("WXZF", "微信"),
    ZFBZF("ZFBZF", "支付宝"),
    UPSMZF("UPSMZF", "银联二维码"),
    ;

    private String code;
    private String desc;

    PayTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PayTypeEnum getByType(String code) {
        PayTypeEnum[] valueList = PayTypeEnum.values();
        for (PayTypeEnum v : valueList) {
            if (v.getCode().equalsIgnoreCase(code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>code</tt>.
     *
     * @return property value of code
     */
    public String getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
