/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 微信刷脸request
 *
 * @author zhaoyi
 * @version LeshuaWxPayFaceRequest.java, v 0.1 2020-07-29 09:50 zhaoyi
 */
@Data
public class LeshuaWxPayFaceRequest extends LeshuaBasePayRequest {


    private static final long serialVersionUID = -3495668084436730748L;

    /**
     * 商户公众账号ID
     * 如要传入就必须要与 sub_mch_id 必须匹配
     */
    private String subAppid;

    /**
     * 微信子商户号
     * 与 sub_appid 必须匹配
     */
    @NotBlank(message = "subMchId不能为空")
    private String subMchId;

    /**
     * 乐刷商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 初始化数据
     * 由微信人脸SDK的接口返回
     */
    @NotBlank(message = "rawData不能为空")
    private String rawData;

    /**
     * 门店编号
     * 由商户定义， 各门店唯一
     */
    @NotBlank(message = "storeId不能为空")
    private String storeId;

    /**
     * 门店名称
     * 由商户定义。（可用于展示）
     */
    @NotBlank(message = "storeName不能为空")
    private String storeName;

    /**
     * 终端设备编号
     * 由商户定义
     */
    @NotBlank(message = "deviceId不能为空")
    private String deviceId;

    /**
     * 活动类型
     * 0：不参加活动
     * 1：银联绿洲活动
     */
    private String activeType;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
