package com.fshows.leshuapay.sdk.request.activity;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaGoldActivityMerchantResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * LsGoldActivityMerchantRequest
 *
 * @author Think
 * @version 1.0
 * @since 2025/11/18
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaGoldActivityMerchantRequest extends LeshuaBizRequest<LeshuaGoldActivityMerchantResponse> {
    private static final long serialVersionUID = 4684721366095752540L;

    /**
     * 代理商编号
     */
    private String agentId;

    /**
     * 签名
     */
    private String sign;

    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 页码
     */
    private Integer pageNo;

    /**
     * 每页记录数
     */
    private Integer pageSize;


    @Override
    public Class<LeshuaGoldActivityMerchantResponse> getResponseClass() {
        return LeshuaGoldActivityMerchantResponse.class;
    }
}