/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant.expired;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author zhaoyi
 * @version MerchantWxPayConfigQueryResponse.java, v 0.1 2020-07-29 12:15 zhaoyi
 */
@Data
public class MerchantCardExpiredListInfoResponse implements Serializable {

    private static final long serialVersionUID = 3012625879690680607L;
    /**
     * 商户id
     */
    private String merchantId;
    /**
     * 身份证过期时间
     */
    private String idCardEndDate;
    /**
     * 证件类型：1-法人，2-非法人
     */
    private Integer certificateType;

    /**
     * 已过期天数；负数未过期
     */
    private Integer idCardExpireDays;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
