/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;

/**
 * 商户补贴信息
 *
 * @author linzy
 * @version SubsidyDetailRequest.java, v 0.1 2022-10-10 上午9:29 linzy
 */
@Data
@JSONType(naming = PropertyNamingStrategy.PascalCase)
public class SubsidyDetailRequest implements Serializable {

    private static final long serialVersionUID = -2858191062660411825L;
    /**
     * 商户编号
     */
    @JSONField(ordinal = 1)
    private String merchantId;
    /**
     * 该商户手续费补贴（单位：分）
     */
    @JSONField(ordinal = 2)
    private Integer serviceFee;
    /**
     * 该商户营销费补贴（单位：分）
     */
    @JSONField(ordinal = 3)
    private Integer marketingFee;

}