/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.share;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;

/**
 * @author mengqf
 * @version CreateAccountAccreditResponse.java, v 0.1 2024-08-19 14:36 mengqf
 */
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class CreateAccountAccreditResponse implements Serializable {
    private static final long serialVersionUID = 6958429191842542560L;

    /**
     * 错误码
     * 0正常返回
     */
    private String retcode;

    /**
     * 错误信息
     */
    private String retmsg;

    /**
     * 乐刷商户号（汇总分账主体商户）
     */
    private String merchantId;

    /**
     * 调用方标注这次汇总分账标识id
     */
    private String thirdId;

    /**
     * 汇总分账状态
     * 0 汇总分账中
     * 1 汇总分账成功
     * 2 汇总分账失败
     * 3 汇总分账撤销中
     * 4 汇总分账撤销成功
     * 5 汇总分账撤销失败
     */
    private String status;

    /**
     * 汇总分账总金额
     */
    private String amount;

    /**
     * 分账手续费计费方式
     * 0：内扣
     * 注：当前仅支持内扣模式
     */
    private String chargeType;

    /**
     * 乐刷分账id
     */
    private String leshuaId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 分账详情
     */
    private String details;

}