/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhoujp
 * @version LeshuaBankActivityInfoResponse.java, v 0.1 2023-07-27 11:04 zhoujp
 */
@Data
public class LeshuaBankActivityInfoResponse implements Serializable {
    private static final long serialVersionUID = 7386944100592043815L;

    /**
     * 活动编号
     */
    private String code;

    /**
     * 活动类型10-月返，20-实时返，30实时返非0
     */
    private String type;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动开始时间:yyyy-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 活动结束时间:yyyy-MM-dd HH:mm:ss
     */
    private String endTime;

    /**
     * 活动地区
     */
    private String address;

    /**
     * 活动说明
     */
    private String desc;

    /**
     * 政策内容
     */
    private LeshuaBankActivityFileInfoResponse fileInfo;

    /**
     * cardBinLength	number	必须		卡bin位数
     */
    private Integer cardBinLength;

    /**
     * 活动卡bin
     */
    private String cardBins;

    /**
     * 是否承担税点，0:不承担，1:承担
     */
    private Integer isBearTax;

    /**
     * 0=不支持开卡，10=上门开卡  20=邮政工资卡 30=网点开卡 40=上门/网点开卡
     */
    private Integer subType;

    /**
     * 活动状态1：未上架；2：进行中；3：已下架；4：已过期
     */
    private Integer activityStatus;

    /**
     * 银行名字
     */
    private String bankName;

    /**
     * 补贴规则
     */
    private LeshuaBankActivityAllowInfoResponse allowanceInfo;

}