/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.response.MerchantIdCardUpdateResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version MerchantIdCardUpdateRequest.java, v 0.1 2025-02-11 14:46 zhangling
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantIdCardUpdateRequest extends LeshuaBizRequest<java.lang.String> {

    /**
     * 乐刷商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String merchantId;
    /**
     * 证件头像面图片地址
     */
    @NotBlank(message = "证件头像面图片地址不能为空")
    private String idcardFront;
    /**
     * 证件国徽面图片地址
     */
    @NotBlank(message = "证件国徽面图片地址不能为空")
    private String idcardBack;
    /**
     * 所传图片是否为法人证件图片证件，1：是，0：否
     */
    @NotBlank(message = "是否为法人证件图片不能为空")
    private String extKey;
    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<java.lang.String> getResponseClass() {
        return java.lang.String.class;
    }
}