/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */package com.fshows.leshuapay.sdk.request.share;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.CreateSumAccreditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author wangyi
 * @version CreateSumAccreditRequest.java, v 0.1 2022-05-19 14:49
 */
@EqualsAndHashCode(callSuper = true)
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class CreateSumAccreditRequest extends LeshuaBizRequest<CreateSumAccreditResponse> {

    /**
     * cmd
     */
    private String cmd;

    /**
     * 分账发起方商户编号
     */
    private String merchantId;

    /**
     * 第三方分账编号
     */
    private String thirdId;

    /**
     * 分账总金额
     */
    private String amount;

    /**
     * 分账备注
     */
    private String remark;

    /**
     * 分账列表
     */
    private String details;

    @Override
    public Class<CreateSumAccreditResponse> getResponseClass() {
        return CreateSumAccreditResponse.class;
    }
}
