/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaMachineBindClient;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaMachineBaseResponse;
import com.fshows.leshuapay.sdk.util.ReqSerialNoUtil;
import com.fshows.leshuapay.sdk.util.SignUtil;
import com.fshows.leshuapay.sdk.util.ValidateUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaMachineBindClientImpl
implements LeshuaMachineBindClient {
    private static final Logger log = LoggerFactory.getLogger(LeshuaMachineBindClientImpl.class);
    private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private String serverUrl;
    private String agentId;
    private String privateKey;
    private Integer timeout;

    public LeshuaMachineBindClientImpl(String serverUrl, String agentId, String privateKey, Integer timeout) {
        this.serverUrl = serverUrl;
        this.agentId = agentId;
        this.privateKey = privateKey;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> LeshuaMachineBaseResponse<T> execute(LeshuaBizRequest<T> request, String url, Integer timeout) throws LeshuaException {
        LeshuaMachineBaseResponse<Object> leshuaMachineBaseResponse;
        ValidateUtil.validateWithThrow(request, new Class[0]);
        String sign = SignUtil.getMerchantSign(request, this.privateKey);
        RequestConfig requestConfig = null;
        requestConfig = timeout == null || timeout <= 0 ? RequestConfig.custom().setConnectionRequestTimeout(10000).setSocketTimeout(10000).setConnectTimeout(10000).build() : RequestConfig.custom().setConnectionRequestTimeout(timeout.intValue()).setSocketTimeout(timeout.intValue()).setConnectTimeout(timeout.intValue()).build();
        HttpPost httppost = new HttpPost(this.serverUrl + url);
        httppost.setConfig(requestConfig);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.setCharset(Charset.forName("utf-8"));
        String reqSerialNo = ReqSerialNoUtil.getReqSerialNo();
        multipartEntityBuilder.addPart("agentId", (ContentBody)new StringBody(this.agentId, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("version", (ContentBody)new StringBody("2.0", ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("reqSerialNo", (ContentBody)new StringBody(reqSerialNo, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("data", (ContentBody)new StringBody(JSON.toJSONString(request), ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("sign", (ContentBody)new StringBody(sign, ContentType.APPLICATION_JSON));
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httppost.setEntity(reqEntity);
        CloseableHttpResponse httpResponse = null;
        HttpEntity resEntity = null;
        try {
            httpResponse = httpclient.execute((HttpUriRequest)httppost);
            resEntity = httpResponse.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            log.info("\u4e50\u5237\u673a\u5177\u8bf7\u6c42\u8fd4\u56de param={};response={}", JSON.toJSON(request), (Object)responseStr);
            LeshuaMachineBaseResponse<Object> response = new LeshuaMachineBaseResponse<Object>();
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response.setReqSerialNo(jsonObject.getString("reqSerialNo"));
            response.setErrorCode(jsonObject.getString("error_code"));
            response.setErrorMsg(jsonObject.getString("error_msg"));
            if (!StringUtils.isBlank((CharSequence)jsonObject.getString("data"))) {
                response.setData(JSON.parseObject((String)jsonObject.getString("data"), request.getResponseClass()));
            }
            leshuaMachineBaseResponse = response;
        }
        catch (Exception e) {
            try {
                throw new LeshuaException("\u8c03\u7528\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                try {
                    EntityUtils.consume(resEntity);
                }
                catch (IOException e2) {
                    log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e2.getMessage(), (Throwable)e2);
                }
                if (httpResponse == null) throw throwable;
                try {
                    httpResponse.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        catch (IOException e) {
            log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (httpResponse == null) return leshuaMachineBaseResponse;
        try {
            httpResponse.close();
            return leshuaMachineBaseResponse;
        }
        catch (IOException e) {
            log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        return leshuaMachineBaseResponse;
    }

    private LeshuaMachineBindClientImpl() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaMachineBindClientImpl)) {
            return false;
        }
        LeshuaMachineBindClientImpl other = (LeshuaMachineBindClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaMachineBindClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaMachineBindClientImpl(serverUrl=" + this.getServerUrl() + ", agentId=" + this.getAgentId() + ", privateKey=" + this.getPrivateKey() + ", timeout=" + this.getTimeout() + ")";
    }
}

