/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.LeshuaShareRefundQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 分账退款查询
 *
 * @author linzy
 * @version RefundQueryRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LeshuaShareRefundQueryRequest extends LeshuaBizRequest<LeshuaShareRefundQueryResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 乐刷订单号
     */
    private String leshuaOrderId;

    /**
     * 第三方订单号
     */
    private String thirdOrderId;

    /**
     * 第三方退款单号
     */
    private String thirdRefundId;

    /**
     * 第三方分账单号
     */
    private String thirdRoyaltyId;

    /**
     * 乐刷分账单号
     */
    private String leshuaRoyaltyId;

    /**
     * 乐刷退款单号
     */
    private String leshuaRefundId;

    @Override
    public Class<LeshuaShareRefundQueryResponse> getResponseClass() {
        return LeshuaShareRefundQueryResponse.class;
    }
}
