/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 店铺地址信息
 *
 * @author zhaoyi
 * @version AddressInfo.java, v 0.1 2020-07-27 14:50 zhaoyi
 */
@Data
public class AddressInfo implements Serializable {

    private static final long serialVersionUID = -7962599491973616474L;
    /**
     * 商户所在省（填写支付宝地区码）
     */
    @NotBlank(message = "商户所在省不能为空")
    @Length(max = 6, message = "商户所在省超长")
    private String provinceCode;

    /**
     * 市（填写支付宝地区码）
     */
    @NotBlank(message = "商户所在市不能为空")
    @Length(max = 6, message = "商户所在市超长")
    private String cityCode;

    /**
     * 区县（无区县的市传街道编码，东莞、中山）（填写支付宝地区码）
     */
    @NotBlank(message = "商户所在区县不能为空")
    @Length(max = 9, message = "商户所在区县超长")
    private String areaCode;

    /**
     * 商户详细地址(5-40个字符)
     */
    @NotBlank(message = "商户详细地址不能为空")
    @Length(max = 40, message = "商户详细地址超长")
    private String address;

}
