/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.alipay;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.request.merchant.settlement.AddressInfo;
import com.fshows.leshuapay.sdk.response.alipay.LeshuaAlipayAntCreateResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zhangmj
 * @version LeshuaActivitySignRequest.java, v 0.1 2022-03-09 上午9:29 zhangmj
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaAlipayAntCreateRequest extends LeshuaBizRequest<LeshuaAlipayAntCreateResponse> {

    /**
     * 乐刷商户id
     */
    private String merchantId;
    /**
     * 店铺类目
     */
    private String shopCategory;
    /**
     * 门店编号
     */
    private String storeId;
    /**
     * 店铺经营类型，01表示直营，02表示加盟
     */
    private String shopType;
    /**
     * 商户角色id
     */
    private String ipRoleId;
    /**
     * 店铺名称
     */
    private String shopName;
    /**
     * 营业执照图片 id
     */
    private String certImage;
    /**
     * 法人名称
     */
    private String legalName;
    /**
     * 法人身份证号
     */
    private String legalCertNo;
    /**
     * 营业执照授权函。其值为使用ant.merchant.expand.indirect.image.upload上传图片得到的一串oss key。
     */
    private String licenseAuthLetterImage;
    /**
     * 店铺联系手机
     */
    private String contactMobile;
    /**
     * 证件号码。请填写店铺营业执照号。
     * 支付宝侧必填，若代理商未填，则乐刷默认取商户进件时提供的。
     */
    private String certNo;
    /**
     * 证件类型，取值范围：201：营业执照；2011:多证合一(统一社会信用代码)
     */
    private String certType;
    /**
     * 营业执照名称(填写值为营业执照或统一社会信用代码证上的名称。)
     */
    private String certName;
    /**
     * 经营地址。地址对象中省、市、区、地址必填，其余选填
     * 支付宝侧必填，若代理商未填，则乐刷默认取商户进件时提供的。
     */
    private LeshuaAlipayAddressInfo addressInfo;

    @Override
    public Class<LeshuaAlipayAntCreateResponse> getResponseClass() {
        return LeshuaAlipayAntCreateResponse.class;
    }
}