/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaConfirmSubsidyResponse;
import lombok.Data;

/**
 * 确认商户补贴信息
 *
 * @author linzy
 * @version LeshuaConfirmSubsidyRequest.java, v 0.1 2022-10-10 上午9:29 linzy
 */
@Data
@JSONType(naming = PropertyNamingStrategy.PascalCase)
public class LeshuaConfirmSubsidyRequest extends LeshuaBizRequest<LeshuaConfirmSubsidyResponse> {

    /**
     * 补贴信息上传批次号（同一代理商和期望补贴日期，再次上传时需要传入此参数）
     */
    @JSONField(ordinal = 1)
    private String subsidyId;
    /**
     * 确认状态 1.确认无误 4.确认废弃
     */
    @JSONField(ordinal = 2)
    private Integer handleStatus;

    @Override
    public Class<LeshuaConfirmSubsidyResponse> getResponseClass() {
        return LeshuaConfirmSubsidyResponse.class;
    }
}