/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant.riskmanagement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.riskmanagement.RiskWorkListResponse;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;

/**
 * @author ruanzeyang
 * @version LeShuaRiskRequest.java, v 0.1 2021-12-08 13:54 ruanzeyang
 */

@Data
public class RiskWorkListRequest extends LeshuaBizRequest<RiskWorkListResponse> {

    /**
     * 直属代理商ID
     */
    private String directAgentId;

    /**
     * 投诉结束日期 精确到日，格式yyyyMMdd
     */
    @NotBlank(message = "结束时间不能为空")
    private String ticketEndTime;

    /**
     * 投诉开始日期 精确到日，格式yyyyMMdd
     */
    @NotBlank(message = "开始时间不能为空")
    private String ticketStartTime;

    /**
     * 被风控的商户号
     */
    private String merchantId;

    /**
     * 风控工单ID
     */
    private String ticketNumber;

    /**
     * 风险来源，1--微信投诉;2--微信违规;3--支付宝违规;4-云闪付;5--乐刷 6--支付宝告警
     */
    private Integer riskSource;

    /**
     * 风险类型
     */
    private Integer riskType;

    /**
     * 分页开始页码 默认0
     */
    private Integer pageNum;

    /**
     * 每页的数据条数 默认20，最大100
     */
    @Max(value = 100, message = "每页数据条数最大100")
    private Integer rows;

    @Override
    public Class<RiskWorkListResponse> getResponseClass() {
        return RiskWorkListResponse.class;
    }
}