package com.fshows.leshuapay.sdk.request.bill;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.bill.AgentInvoiceDetailResponse;
import com.fshows.leshuapay.sdk.response.bill.AgentInvoiceListResponse;
import lombok.Data;

/**
 * @author huanghai
 * @version 1.0 AgentInvoiceListRequest
 * @date 2021/11/23 16:48
 */
@Data
public class AgentInvoiceDetailRequest extends  LeshuaBizRequest<AgentInvoiceDetailResponse> {
    /**
     * 发票申请id,申请开票接口有返回,此字段和商户id至少要传一个
     */
    private Long id;

    /**
     * 商户id，此字段和id至少要传一个
     */
    private  String merchantId;
    /**
     * 页码
     */
    private Integer  pageNo;

    @Override
    public Class<AgentInvoiceDetailResponse> getResponseClass() {
        return AgentInvoiceDetailResponse.class;
    }
}
