/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author zhaoyi
 * @version LeshuaBasePayResponse.java, v 0.1 2020-07-28 10:40 zhaoyi
 */
@Data
public class LeshuaBasePayResponse implements Serializable {

    private static final long serialVersionUID = 8399796290059433242L;
    /**
     * 业务结果，0成功，非0失败
     **/
    public String resultCode;
    /**
     * 错误码
     **/
    public String errorCode;
    /**
     * 错误描述
     **/
    public String errorMsg;
    /**
     * 随机字符串
     **/
    public String nonceStr;
    /**
     * MD5签名
     **/
    public String sign;
    /**
     * 响应状态码，0代表成功，非0代表成功
     **/
    protected String respCode;
    /**
     * 错误信息，resp_code非0时返回
     **/
    protected String respMsg;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
