/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import com.fshows.leshuapay.sdk.request.merchant.rate.AlipayRate;
import com.fshows.leshuapay.sdk.request.merchant.rate.CardRate;
import com.fshows.leshuapay.sdk.request.merchant.rate.UnionScan2Rate;
import com.fshows.leshuapay.sdk.request.merchant.rate.UnionScanRate;
import com.fshows.leshuapay.sdk.request.merchant.rate.WxRate;
import lombok.Data;

import java.io.Serializable;

/**
 * 商户费率查询request
 *
 * @author zhaoyi
 * @version MerchantRateQueryResponse.java, v 0.1 2020-07-30 11:50 zhaoyi
 */
@Data
public class MerchantRateQueryResponse implements Serializable {

    private static final long serialVersionUID = 1398511517288083605L;

    /**
     * 微信扫码费率
     */
    private WxRate weixin;

    /**
     * 支付宝扫码费率
     */
    private AlipayRate alipay;

    /**
     * 刷卡费率
     */
    private CardRate card;

    /**
     * 银联扫码费率-大于1000
     */
    private UnionScanRate unionScan;

    /**
     * 银联扫码费率-小于等于1000
     */
    private UnionScan2Rate unionScan2;


}
