/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.share;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.QuerySumAccreditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wangyi
 * @version QuerySumAccreditRequest.java, v 0.1 2022-05-19 15:12
 */
@EqualsAndHashCode(callSuper = true)
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class QuerySumAccreditRequest extends LeshuaBizRequest<QuerySumAccreditResponse> {

    /**
     * cmd
     */
    private String cmd;

    /**
     * 分账发起方商户编号
     */
    private String merchantId;

    /**
     * 第三方分账编号
     */
    private String thirdId;

    @Override
    public Class<QuerySumAccreditResponse> getResponseClass() {
        return QuerySumAccreditResponse.class;
    }
}
