/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.AccreditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 分账授权申请
 *
 * @author linzy
 * @version AccreditRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AccreditRequest extends LeshuaBizRequest<AccreditResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 商户基础信息
     */
    private BaseInfo baseInfo;

    /**
     * 营业执照信息
     */
    private LicenseInfo licenseInfo;

    /**
     * 其它信息
     */
    private OtherInfo otherInfo;

    /**
     * 商户拟使用的分账方式
     * 1：订单分账
     * 2：余额分账
     */
    private Integer ledgerMethod;

    /**
     * 收费设置
     */
    private FeeRate feeRate2;

    @Override
    public Class<AccreditResponse> getResponseClass() {
        return AccreditResponse.class;
    }
}
