/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSettlePeriodCheckResponse;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSettlePeriodUpdateResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 商户自定义结算周期更新
 *
 * @author wangyi
 * @version MerchantSettlePeriodUpdateRequest.java, v 0.1 2023-08-03 10:03 wangyi
 */
@Data
public class MerchantSettlePeriodUpdateRequest extends LeshuaBizRequest<MerchantSettlePeriodUpdateResponse> {

    private static final long serialVersionUID = 4139295818341073065L;

    /**
     * 商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 要开通的周期，必须为"0-23"之间
     */
    @NotBlank(message = "period不能为空")
    private String period;

    /**
     * 开通原因
     */
    private String reason;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantSettlePeriodUpdateResponse> getResponseClass() {
        return MerchantSettlePeriodUpdateResponse.class;
    }
}