/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 营业资质信息
 * <p>
 * 注：小微进件不要传此对象
 *
 * @author zhaoyi
 * @version LicenseInfo.java, v 0.1 2020-07-27 14:50 zhaoyi
 */
@Data
public class LicenseInfo implements Serializable {

    private static final long serialVersionUID = -3309173726774129000L;
    /**
     * 营业执照注册号(企业，个体户必填)
     */
    @Length(max = 18, message = "营业执照注册号超长")
    private String license;

    /**
     * 营业执照名称，执照如无名称，可填“个体户XXX”（执照上姓名）
     */
    @Length(max = 40, message = "营业执照名称超长")
    private String licenseFullName;

    /**
     * 营业执照注册地址(企业，个体户必填)
     */
    @Length(max = 20, message = "营业执照注册地址超长")
    private String licenseAddress;

    /**
     * 营业执照注册号开始日期(企业，个体户必填)格式：2015-09-22
     */
    @Length(max = 32, message = "营业执照注册号开始日期超长")
    private String licenseStart;


    /**
     * 营业执照注册结束日期(企业，个体户必填)格式：2015-09-22，永久有效:长期
     */
    @Length(max = 32, message = "营业执照注册结束日期超长")
    private String licenseEnd;

    /**
     * 营业执照(企业，个体户必填)图片地址
     */
    private String licensePic;
}
