/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 联系人信息
 *
 * @author zhaoyi
 * @version ContactInfo.java, v 0.1 2020-07-27 14:30 zhaoyi
 */
@Data
public class ContactInfo implements Serializable {
    private static final long serialVersionUID = -5077409300375749689L;

    /**
     * 联系人姓名(与法人一致)
     */
    @NotBlank(message = "联系人姓名不能为空")
    @Length(min = 2, max = 20, message = "联系人姓名超长")
    private String name;

    /**
     * 手机号码（11位手机号）
     */
    @NotBlank(message = "手机号码不能为空")
    @Length(max = 11, message = "手机号码超长")
    private String mobile;

}
