/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantSettlementStatusResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户结算状态查询
 *
 * @author linzy
 * @version MerchantSettlementStatusRequest.java, v 0.1 2020-07-29 14:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantSettlementStatusRequest extends LeshuaBizRequest<MerchantSettlementStatusResponse> {

    /**
     * 商户编号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;


    @Override
    public Class<MerchantSettlementStatusResponse> getResponseClass() {
        return MerchantSettlementStatusResponse.class;
    }

}
