/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaInsertSubsidyResponse;
import lombok.Data;

import java.util.List;

/**
 * 上传商户补贴信息
 *
 * @author linzy
 * @version LeshuaInsertSubsidyRequest.java, v 0.1 2022-10-10 上午9:29 linzy
 */
@Data
@JSONType(naming = PropertyNamingStrategy.PascalCase)
public class LeshuaInsertSubsidyRequest extends LeshuaBizRequest<LeshuaInsertSubsidyResponse> {

    /**
     * 期望补贴日期，格式 yyyy-MM-dd，应从今天开始。示例：2018-07-16
     */
    @JSONField(ordinal = 1)
    private String subsidyDate;
    /**
     * 这批手续费补贴总计（单位:分）
     */
    @JSONField(ordinal = 2)
    private Integer totalServiceFee;
    /**
     * 这批营销费补贴总计（单位：分）
     */
    @JSONField(ordinal = 3)
    private Integer totalMarketingFee;
    /**
     * 这批补贴费用总计（包括手续费、营销费。单位：分）
     */
    @JSONField(ordinal = 4)
    private Integer totalSubsidyFee;
    /**
     * 这批次补贴商户数
     */
    @JSONField(ordinal = 5)
    private Integer totalMerchantCount;
    /**
     * 补贴详情
     */
    @JSONField(ordinal = 6)
    private List<SubsidyDetailRequest> subsidyDetailList;

    @Override
    public Class<LeshuaInsertSubsidyResponse> getResponseClass() {
        return LeshuaInsertSubsidyResponse.class;
    }
}