/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaBankActivityListResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zhoujp
 * @version LeshuaBankActivityListRequest.java, v 0.1 2023-07-27 10:28 zhoujp
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaBankActivityListRequest extends LeshuaBizRequest<LeshuaBankActivityListResponse> {

    /**
     * 签名
     */
    private String sign;
    /**
     * 代理商编号
     */
    private String agentId;
    /**
     * 当前页
     */
    private Integer pageNo;
    /**
     * 页大小
     */
    private Integer pageSize;


    @Override
    public Class<LeshuaBankActivityListResponse> getResponseClass() {
        return LeshuaBankActivityListResponse.class;
    }
}