/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.request.pay.LeshuaBasePayRequest;
import com.fshows.leshuapay.sdk.response.pay.LeshuaBasePayResponse;

/**
 * @author zhaoyi
 * @version LeshuaPayClient.java, v 0.1 2020-07-28 09:40 zhaoyi
 */
public interface LeshuaPayClient<Req extends LeshuaBasePayRequest, Res extends LeshuaBasePayResponse> {

    /**
     * 乐刷交易接口，默认超时时间
     *
     * @param reqData
     * @param resClass
     * @return
     * @throws Exception
     */
    Res execute(Req reqData, Class<Res> resClass) throws Exception;

    /**
     * 乐刷交易接口，自定义超时时间
     *
     * @param reqData
     * @param resClass
     * @param timeout
     * @return
     * @throws Exception
     */
    Res execute(Req reqData, Class<Res> resClass, Integer timeout) throws Exception;

    /**
     * 乐刷交易接口
     *
     * @param reqData
     * @param apiKey
     * @param payServerUrl
     * @param timeout
     * @param resClass
     * @return
     * @throws Exception
     */
    Res execute(Req reqData, String apiKey, String payServerUrl, Class<Res> resClass, Integer timeout) throws Exception;
}
