/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 商户审核查询response
 *
 * @author zhaoyi
 * @version MerchantAuditQueryResponse.java, v 0.1 2020-07-30 11:15 zhaoyi
 */
@Data
public class MerchantAuditQueryResponse implements Serializable {

    private static final long serialVersionUID = -233903985447655258L;

    /**
     * REJECTED 退回
     * REVIEW 待人工检查
     * PASSED 通过
     * UNKNOWN 未知
     * ADD_INFO 待完善资料
     * AUDITING 待审核
     */
    private String merchantStatus;

    /**
     * 商户审核信息
     */
    private String auditMsg;

    /**
     * 拒绝原因分类
     * 商户信息错误
     * 营业执照信息错误
     * 证件信息错误
     * 结算账户信息错误
     * 系统拒绝
     *
     * 一次性可以返回多个分类，用英文,隔开
     */
    private String rejectReasonType;

    /**
     * 拒绝驳回原因
     * 具体明细原因
     */
    private String refusalReason;

    /**
     * 审核时间 (2018-11-01 11:22:33)
     */
    private String auditDateTime;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
