/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author linzy
 * @version OpenAutoCollectRequest.java, v 0.1 2022-05-19 14:49
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OpenAutoCollectRequest extends LeshuaBizRequest<LeshuaBaseResponse> {


    /**
     * 分账发起方商户编号
     */
    private String merchantId;

    /**
     * 扫码分账标记：0未开通，1已开通
     */
    private Integer unionShareType;

    /**
     * 快捷分账标记：0未开通，1已开通
     */
    private Integer quickShareType;

    /**
     * 刷卡分账标记：0未开通，1已开通
     */
    private Integer cardShareType;

    /**
     * 自动分账权限：0未开通，1已开通
     */
    private Integer autoShareType;

    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }
}
