/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSettlePeriodCheckResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 商户自定义结算周期检测
 *
 * @author wangyi
 * @version MerchantSettlePeriodCheckRequest.java, v 0.1 2023-08-03 10:03 wangyi
 */
@Data
public class MerchantSettlePeriodCheckRequest extends LeshuaBizRequest<MerchantSettlePeriodCheckResponse> {

    private static final long serialVersionUID = 3346947163760962859L;

    /**
     * 商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantSettlePeriodCheckResponse> getResponseClass() {
        return MerchantSettlePeriodCheckResponse.class;
    }
}