/**
 * fshows.com Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.riskmanagement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.riskmanagement.RiskCommitResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 风控提交
 *
 * @author chenll
 * @version MerchantSettleRequest.java, v 0.1 2020-07-27 11:50 chenll
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RiskCommitRequest extends LeshuaBizRequest<RiskCommitResponse> {

    /** 默认填2 */
    private Integer sourceCode;

    /** 工单编号 */
    private String ticketNumber;

    /** 交易类型;1-刷卡,快捷;2-扫码 */
    private Integer txnType;

    /** 风险来源 1--微信投诉;2--微信违规;3--支付宝违规; 4--云闪付;5--乐刷，6--支付宝告警 */
    private Integer riskSource;

    /** 商户编号 */
    private String merchantId;

    /** 商户类型，默认传1 */
    private Integer merchantAuthenticity;

    /**
     * 申诉资料类型; 1--扫码交易,真实商户,云闪付|乐刷|微信投诉|支付宝告警来源申诉资料; 2--扫码交易,微信违规来源申诉资料; 3--扫码交易,支付宝违规来源申诉资料;
     * 4--扫码交易,(微信违规,支付宝违规)申诉失败,转向乐刷解冻申诉资料; 5--刷卡,快捷交易,真实商户和非真实,云闪付和乐刷来源申诉资料;
     * 6--扫码交易,非真实商户,云闪付|乐刷|微信投诉|支付宝告警来源申诉资料
     */
    private Integer appealInfoType;

    /** 申诉资料详情json */
    private String appealMaterial;

    /** 签名 */
    private String sign;

    @Override
    public Class<RiskCommitResponse> getResponseClass() {
        return RiskCommitResponse.class;
    }
}
