/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 支付类型
 *
 * @author zhaoyi
 * @version JspayFlagEnum.java, v 0.1 2020-08-03 15:05 zhaoyi
 */
public enum JspayFlagEnum {
    SCAN_CODE(0, "支付宝扫码支付、银联二维码扫码支付"),
    ORIGIN(1, "微信公众号、支付宝服务窗支付<原生支付>、银联js支付"),
    SIMPLE(2, "微信公众号、支付宝服务窗支付<简易支付>"),
    MINA_APP(3, "微信小程序支付、支付宝小程序支付"),
    ;

    private Integer type;
    private String desc;

    JspayFlagEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static JspayFlagEnum getByType(Integer type) {
        JspayFlagEnum[] valueList = JspayFlagEnum.values();
        for (JspayFlagEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
