/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * 商户账户提现费率查询 response
 *
 * @author zhaoxumin
 * @version MerchantGetWithdrawFeeResponse.java, v 0.1 2024-03-29 zhaoxumin
 */
@Data
public class MerchantWithdrawFeeDetailResponse implements Serializable {

    private static final long serialVersionUID = 987538295772805967L;

    /**
     * 提现费率类型. T0：提现秒到费率 T1：提现次日到费率
     */
    private String settleType;

    /**
     * 手续费收费模式. 0：按比例收费 1：按笔固定收费
     */
    private Integer type;

    /**
     * 提现费率（低精度）. 20代表0.2%
     */
    private Integer fee;

    /**
     * 提现费率（高精度）. 2000代表0.2%
     */
    private Integer highPrecisionFee;

    /**
     * 每笔提现固定手续费金额，单位万分之一分，如270000表示0.27元
     */
    private Integer feeFixed;
}
