/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @author zhaoyi
 * @version LeshuaQrAndJsPayResponse.java, v 0.1 2020-07-28 11:00 zhaoyi
 */
@Data
public class LeshuaQrAndJsPayResponse extends LeshuaBasePayResponse {


    private static final long serialVersionUID = 1231886823796064462L;

    /**
     * 附加数据
     * 原样返回；注意：只能是汉字、英文字母、数字
     */
    private String attach;

    /**
     * 乐刷商户号
     **/
    private String merchantId;

    /**
     * 通道商户号
     * 微信、支付宝、QRC商户号
     */
    private String subMerchantId;

    /**
     * 商户订单号
     * 商户内部订单号
     **/
    private String thirdOrderId;

    /**
     * 二维码链接
     * 非公众号支付返回，可直接通过该链接生成二维码扫码支付
     **/
    private String tdCode;

    /**
     * 支付信息
     * 原生公众号、服务窗、小程序，json格式字符串、银联JS支付返回URL，用云闪付打开此链接即可调起支付
     **/
    private String jspayInfo;

    /**
     * 支付跳转地址
     * 简易支付时返回。重定向到该url可以完成后续支付流程。
     */
    private String jspayUrl;

    /**
     * 乐刷订单号
     **/
    private String leshuaOrderId;

    /**
     * 支付类型
     **/
    private String payWay;

    /**
     * 请求耗时
     * 请求接口耗费的时间
     */
    private String costTime;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
