/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.activity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhoujp
 * @version LeshuaBankActivityInfoResponse.java, v 0.1 2023-07-27 11:04 zhoujp
 */
@Data
public class LeshuaBankActivityAllowInfoResponse implements Serializable {
    private static final long serialVersionUID = 7386944100592043815L;

    /**
     * 支付宝费率（%）
     */
    private BigDecimal zfbFeeRate;

    /**
     * 微信费率（%）
     */
    private BigDecimal wxFeeRate;

    /**
     * 云闪付费率，d+1费率<=1000（%）
     */
    private BigDecimal cloudPayDbasicFeeRate;

    /**
     * 云闪付费率，d+1费率大于1000（%）
     */
    private BigDecimal cloudPayDoverflowFeeRate;

    /**
     * 贷记卡费率（%）
     */
    private BigDecimal creditFeeRate;

    /**
     * 借记卡费率（%）
     */
    private BigDecimal debitFeeRate;

    /**
     * 补贴规则金额范围最小值 （单位元）
     */
    private String allowanceAmountMin;

    /**
     * 补贴规则金额范围最大值 （单位元）
     */
    private String allowanceAmountMax;

    /**
     * 单笔最大补贴（单位元）
     */
    private String maxAllowance;

    /**
     * 补贴金额限制,0:存量初始,1:不限制,2:自定义
     */
    private Integer allowanceAmountLimit;

}