/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant.riskmanagement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @author ruanzeyang
 * @version RiskWorkSubmitRequest.java, v 0.1 2021-12-09 9:12 ruanzeyang
 */
@Data
public class RiskWorkSubmitRequest extends LeshuaBizRequest<String> {

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String merchantId;

    /**
     * 风控工单ID
     */
    @NotBlank(message = "风控工单ID不能为空")
    private String ticketNumber;

    /**
     * 风控提交对象
     */
    @NotEmpty(message = "列表不能为空")
    private List<RiskWorkMaterialRequest> ticketMaterialDtoList;

    @Override
    public Class<String> getResponseClass() {
        return String.class;
    }

}