package com.fshows.leshuapay.sdk.request.merchant.riskmanagement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.riskmanagement.RiskListResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 风控列表查询
 *
 * @author chenll
 * @version MerchantSettleRequest.java, v 0.1 2020-07-27 11:50 chenll
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RiskListRequest extends LeshuaBizRequest<RiskListResponse> {

    /**
     * 代理商编号
     */
    private String agentId;

    /**
     * 商户编号
     */
    private String merchantId;

    /**
     * 创建时间起点 yyyy-MM-dd HH:mm:ss
     */
    private String createTimeStart;

    /**
     * 创建时间终点yyyy-MM-dd HH:mm:ss
     */
    private String createTimeEnd;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 页号
     */
    private String pageNo;

    /**
     * sign值
     */
    private String sign;

    @Override
    public Class<RiskListResponse> getResponseClass() {
        return RiskListResponse.class;
    }
}
