/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.rate;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 联二维码扫码费率
 * 设置的是大于1000的费率
 *
 * @author zhaoyi
 * @version UnionScanRate.java, v 0.1 2020-07-30 9:53 zhaoyi
 */
@Data
public class UnionScanRate implements Serializable {

    private static final long serialVersionUID = -1565043458657599594L;
    /**
     * 次日结算贷记卡费率(刷卡或银联扫码支付必传)
     */
    private FeeUnit t1Credit;

    /**
     * 次日结算借记卡费率(刷卡或银联扫码支付必传)
     */
    private FeeUnit t1Debit;

    /**
     * 次日结算境外卡费率(刷卡支付必传)
     */
    private FeeUnit t1OverSee;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
