/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.request.basic.BankBranchRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.response.basic.BankBranchListResponse;

import java.util.List;

/**
 * 基础数据查询
 *
 * @author zhaoyi
 * @version LeshuaBasicClient.java, v 0.1 2020-07-29 15:57 zhaoyi
 */
public interface LeshuaBasicClient<Req, Res> {

    /**
     * 基础数据查询
     *
     * @param request  请求参数
     * @param resClass 响应类
     * @param url      实际业务请求地址
     * @return
     */
    LeshuaBaseResponse<List<Res>> execute(Req request, Class<Res> resClass, String url);

    /**
     * 支行信息查询
     *
     * @param request 支行信息查询入参
     * @param url     实际业务请求地址
     * @return
     */
    LeshuaBaseResponse<BankBranchListResponse> queryBankBranch(BankBranchRequest request, String url);
}
