package com.fshows.leshuapay.sdk.response.repayment;

import lombok.Data;

import java.io.Serializable;

/**
 * @author songjian * @version RepaymentItemResponse.java, v 0.1 2025-04-17 14:33 songjian
 */
@Data
public class RepaymentItemResponse implements Serializable {
    private static final long serialVersionUID = -3145838108856491398L;
    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 申请创建时间（格式：yyyy-MM-dd HH:mm:ss）
     */
    private String createTime;

    /**
     * 重打款申请单号
     */
    private String applicationId;

    /**
     * 申请状态（0-已重打款，1-待重打款）
     */
    private String applicationStatus;

    /**
     * 原始打款单编号
     */
    private String billId;

    /**
     * 到账状态（0-已到账，1-未到账）
     */
    private Integer state;

    /**
     * 实付金额（单位：分）
     */
    private Long realAmount;

    /**
     * 打款单创建时间（格式：yyyy-MM-dd HH:mm:ss）
     */
    private String billCreateTime;

    /**
     * 最后更新时间（格式：yyyy-MM-dd HH:mm:ss）
     */
    private String updateTime;

    /**
     * 失败原因（成功时为空）
     */
    private String failReason;

    /**
     * 最新退票单号（无退票时为空）
     */
    private String lastRefundBillId;
}
