/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhoujp
 * @version LeshuaBankActivityQuotaDetailsInfoResponse.java, v 0.1 2023-07-27 11:04 zhoujp
 */
@Data
public class LeshuaBankActivityQuotaDetailsInfoResponse implements Serializable {

    private static final long serialVersionUID = 2114636946995199505L;
    /**
     * 商户编号
     */
    private String merchantId;

    /**
     * 额度包周期，自然月：yyyyMM,跨月yyyy/MM/dd-yyyy/MM/dd
     */
    private String period;

    /**
     * 补贴时间,yyyy-MM-dd HH:mm:ss
     */
    private String allowanceTime;

    /**
     * 交易金额（单位元）
     */
    private String amount;

    /**
     * 补贴金额（单位元）
     */
    private String allowanceAmount;

    /**
     * 对额度包余额（单位元）
     */
    private String balance;

    /**
     * 资金流向：0-出账，1-入账
     */
    private String isEntry;

    /**
     * 订单编号
     */
    private String orderId;


}