/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.expired;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantWxPayConfigQueryResponse;
import com.fshows.leshuapay.sdk.response.merchant.expired.MerchantCardExpiredQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户支付参数查询request
 *
 * @author zhaoyi
 * @version MerchantWxPayConfigQueryRequest.java, v 0.1 2020-07-29 14:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantCardExpiredQueryRequest extends LeshuaBizRequest<MerchantCardExpiredQueryResponse> {

    private static final long serialVersionUID = -6585834487758669600L;
    /**
     * 商户编号
     */
    @NotBlank(message = "merchantId不能为空")
    @Length(max = 10, message = "merchantId超长")
    private String merchantId;


    @Override
    public Class<MerchantCardExpiredQueryResponse> getResponseClass() {
        return MerchantCardExpiredQueryResponse.class;
    }

}
