package com.fshows.leshuapay.sdk.enums;

import cn.hutool.core.util.StrUtil;

/**
 * @author songjian * @version RepaymentEnum.java, v 0.1 2025-04-17 14:52 songjian
 */
public enum RepaymentEnum {
    REPAYMENT("重打款申请", "/repayment/apply"),
    REPAYMENT_QUERY("重打款申请结果查询", "/repayment/page"),
    ;

    private String name;
    private String value;

    RepaymentEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static RepaymentEnum getByValue(String value) {
        RepaymentEnum[] valueList = RepaymentEnum.values();
        for (RepaymentEnum v : valueList) {
            if (StrUtil.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}